/**
* \file: application_fw_constants.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: adit-hmi
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef HMI_INTERFACES_INCLUDE_APPLICATION_FW_CONSTANTS_H_
#define HMI_INTERFACES_INCLUDE_APPLICATION_FW_CONSTANTS_H_


#ifdef __cplusplus
extern "C" {
#endif

/**
 * This enumeration lists all known application states.
 * They are known in HMI as well as on application side and are transmitted via
 * dbus as unsigned integer.
 */
typedef enum tba_app_state_t
{
	/**
	 * Application has been initialized. We are now waiting for the HMI to show up.
	 */
	TBA_STATE_INIT					= 0,

	/**
	 * HMI is available. We are now doing all the negotiation stuff with the HMI.
	 * In this phase, a surface id will be made available to the application.
	 */
	TBA_STATE_HMI_NEGOTIATION		= 1,

	/**
	 * The application is in background state. The HMI turns the off the surface of the application
	 * when this state is entered. The application shall stop work that does not make any sense without
	 * having a visible surface (stop rendering, ...) to save resources (CPU time).
	 */
	TBA_STATE_BACKGROUND			= 2,

	/**
	 * The applications is foreground state. The HMI turns the on the surface of the application when
	 * this state is entered. The application must start rendering as soon as this state is entered.
	 *
	 * The respective callback of the application is called synchronously before the state change
	 * is signaled to the HMI. This way, the application can start rendering before the HMI changes the
	 * visibility of the surface preventing any flickering.
	 */
	TBA_STATE_FOREGROUND			= 3,

	/**
	 * Applications are in this state if they are not able to provide any service (e.g. a no smart phone is connected).
	 * The HMI switches off the surface when the application enters this state. Additional, the button in the HMI used
	 * to bring the application in state foreground is disabled.
	 */
	TBA_STATE_NOSERVICE				= 4,

	/**
	 * The application is in shutdown state. This state is entered during shutdown to prepare an application for
	 * shutting down the head unit. Before entering this state, an application must store all persistent data and
	 * finally enter in a safe state not doing anything any longer. The API provides transition callbacks, which
	 * can be used by the application to synchronize the transition into this state with their preparation work.
	 *
	 * An application must be able to transition back into its active state. This case happens if an ongoing
	 * shutdown is canceled. Respective transition callbacks are provided as well.
	 */
	TBA_STATE_SHUTDOWN				= 5,

	/**
	 * This state is entered when the application framework library runs into an issue that is not recoverable.
	 * A message and a error code can be read out using the API.
	 *
	 * This application can escape out of this state by deinitalizing and reinitializing the library again.
	 * From an HMI point of view, this recovery proceeding looks like a vanishing and reappearing application.
	 */
	TBA_STATE_ERROR					= 6,

	/**
	 * The application framework library is in this state when it has not yet been initialized or after it has
	 * been deinitialized.
	 */
	__TBA_STATE_UNSET				= 0xFF
} tba_app_state_t;

#ifdef __cplusplus
}
#endif

#endif
